
<?php $__env->startSection('title'); ?>
    <?php echo app('translator')->get('academics.pricing_plan'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('mainContent'); ?>
    <section class="sms-breadcrumb mb-20">
        <div class="container-fluid">
            <div class="row justify-content-between">
                <h1><?php echo app('translator')->get('academics.pricing_plan'); ?></h1>
                <div class="bc-pages">
                    <a href="<?php echo e(route('dashboard')); ?>"><?php echo app('translator')->get('academics.dashboard'); ?></a>
                    <a><?php echo app('translator')->get('academics.academics'); ?></a>
                    <a href="<?php echo e(route('tracks')); ?>"><?php echo app('translator')->get('academics.tracks'); ?></a>
                    <a><?php echo app('translator')->get('academics.pricing_plan'); ?></a>
                </div>
            </div>
        </div>
    </section>

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">


            <div class="row">
                <!-- Form Section -->

                <!-- Track List Section -->
                <div class="col-md-8">
                    <div class="white-box">
                        <div class="main-title">
                            <h3 class="mb-15"><?php echo app('translator')->get('academics.pricing_plan'); ?></h3>
                        </div>
                        <form action="<?php echo e(route('track-pricing-plan.store', ['id' => $track->id])); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="track_id" value="<?php echo e($track->id); ?>">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th class="title-td" style="width: 160px"><?php echo e(__('common.pricing_plan_type')); ?></th>
                                        <?php $__currentLoopData = $tracktypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <th><span class="title-td"><?php echo e($item->name); ?></span></th>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $pricing_plan_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><span class="title-td"><?php echo e($plan->name); ?></span></td>
                                            <?php $__currentLoopData = $tracktypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tracktype): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <td>
                                                    <input type="text"
                                                        name="pricing[<?php echo e($plan->id); ?>][<?php echo e($tracktype->id); ?>]"
                                                        class="form-control price-input"
                                                        value="<?php echo e($pricing_data[$plan->id][$tracktype->id] ?? ''); ?>">
                                                </td>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                            <div id="submit-button">
                                <button type="submit" class="btn btn-success">Add <i class="fa fa-plus"></i></button>
                            </div>

                        </form>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="main-title">
                        <h3 class="mb-15"><?php echo app('translator')->get('academics.discount_plan'); ?></h3>
                    </div>
                    <div class="primary_input">
                        <label class="primary_input_label" for=""><?php echo app('translator')->get('academics.discount_plan'); ?>
                        </label>
                        <select class="primary_select  form-control<?php echo e($errors->has('discount_plan') ? ' is-invalid' : ''); ?>"
                            name="discount_plan" id="discount_plan">
                            <?php $__currentLoopData = $discount_plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($plan->id); ?>" <?php echo e($plan->id); ?>>
                                    <?php echo e($plan->name_en); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>

                        <?php if($errors->has('discount_plan')): ?>
                            <span class="text-danger invalid-select" role="alert">
                                <?php echo e($errors->first('discount_plan')); ?>

                            </span>
                        <?php endif; ?>
                    </div>

                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<style>
    .table tbody td {
        padding: 10px !important;
    }

    .title-td,
    .title-th,
    .form-control {
        font-size: 13px !important;
        color: #53639b !important;
    }
</style>




<?php $__env->startPush('scripts'); ?>
    <script>
        $(document).ready(function() {
            function checkInputValues() {
                let hasValue = false;
                $('.price-input').each(function() {
                    const value = $(this).val().trim();
                    if (value !== '') {
                        hasValue = true;
                        return false;
                    }
                });
                if (hasValue) {
                    $('#submit-button').html(
                        "<button type='submit' class='btn btn-danger'>Update</button>"
                    );
                } else {
                    $('#submit-button').html(
                        "<button type='submit' class='btn btn-success'>Add</button>"
                    );
                }
            }
            checkInputValues();
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backEnd.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\tailors-dev\upedia\resources\views/backEnd/academics/trackspricingplan.blade.php ENDPATH**/ ?>